#include <iostream>
#include <ctime>
#include <cstdlib>
#include <algorithm>

using namespace std;

int partition(int arr[], int low, int high) {
    int pivot = arr[low + (high - low) / 2]; 
    int i = low - 1;
    int j = high + 1;
    while (true) {
        do {i++;} 
        while (arr[i] < pivot);
        do {j--;} 
        while (arr[j] > pivot);
        if (i >= j) {return j;}
        swap(arr[i], arr[j]);
    }
}

void quickSort(int arr[], int low, int high) {
    if (low < high) {
        int pi = partition(arr, low, high);
        quickSort(arr, low, pi);
        quickSort(arr, pi + 1, high);
    }
}

void printArray(int arr[], int size) {
    for (int i = 0; i < size; i++)
        cout << arr[i] << " ";
    cout << std::endl;
}

int main() {
    srand(time(NULL));
    int data[35] = {};
    int n = 35;
    for (int i=0; i<35; i++){
        data[i]=(rand()%10)+100;
    }
    cout << "Tablica przed sortowaniem: " << endl;
    printArray(data, n);
    cout << "-----------------------" << endl;
    quickSort(data, 0, n - 1);
    cout << "Tablica po sortowaniu (Quicksort): " << endl;
    printArray(data, n);
    
    return 0;
}